MAX_RESCUE_SERF_COUNT = 10
NECCSSARY_SERF_COUNT = 10
function CreateQuestRescueSerfs()

	StartSimpleJob("QuestRescueSerfs")

	SerfDeadCounter = 0
	SerfRescuedCounter = 0
	
	serfFollowTarget = "Dario"
	
	--Activate and Update QuestInformation
	GUIQuestTools.StartQuestInformation("Serf", "CM02_07_FleeOrFight/QI_rescueSerfs", 1, 1)	
	UpdateAmountOfRescuedAndDeadSerfsInQuestInformation()
	
end

function QuestRescueSerfs()

	if not IsBriefingActive() and not IsCutsceneActive() then

		destroySerfQuest 		= 	{}
		
		for i=1,MAX_RESCUE_SERF_COUNT do
			
			local SerfName = "P4_RescueSerf_"..i
						
			CreateSerfNPC(SerfName)

			-- destroy quest
			destroySerfQuest[i]				=	{}
			destroySerfQuest[i].Target 		= 	SerfName
			destroySerfQuest[i].Callback 	= 	RescueSerfDiedCallback
		
			SetupDestroy(destroySerfQuest[i])	
		
			-- expedition quest
			local expeditionQuest 			= 	{}
			expeditionQuest.EntityName 		= 	SerfName
			expeditionQuest.TargetName		=	"P1_Headquarter"
			expeditionQuest.Distance		=	4000
			expeditionQuest.Callback		=	RescueSerfHQReachedCallback
			expeditionQuest.linkToDestroy 	= 	destroySerfQuest[i]
			
			SetupExpedition(expeditionQuest)
			
			-- Serf can be attacked
			SetHostile(2,4)
			
		end
		
		return true
		
	end		

end

function RescueSerfHQReachedCallback(_Quest)

	DestroyQuest(_Quest.linkToDestroy)

	-- give resources to player
	--AddGold(200)
--	SpokenMessage(String.Key("M_RescueSerfHQReachedCallback"))
	ChangePlayer(_Quest.EntityName, 5)
	
	local npc = {}
	npc.name = _Quest.EntityName
	DestroyNPC(npc)

	-- move serf to new position
	Move(_Quest.EntityName, GetPosition("SerfTargetPos"))

	SerfRescuedCounter = SerfRescuedCounter + 1
	
	if SerfRescuedCounter >= NECCSSARY_SERF_COUNT then
		SetAllSerfsRescued()
	else
		--UpdateQuestInformationCounter
		UpdateAmountOfRescuedAndDeadSerfsInQuestInformation()
	end	
		
end

function SetAllSerfsRescued()

	allSerfsRescued = true
	
	--Disable QuestInformation
	GUIQuestTools.DisableQuestInformation()

	-- Disable lost condition
	if RescueQuestDefeatId ~= nil then
		
		for i=1,table.getn(RescueQuestDefeatId) do
			
			RemoveDefeatCondition(RescueQuestDefeatId[i])
		
		end
		
	end
	
end

function AllSerfsRescued()

	return allSerfsRescued == true

end

function RescueSerfDiedCallback(_Quest)

	SerfDeadCounter = SerfDeadCounter + 1
	
	-- Only one left
	if (SerfDeadCounter + NECCSSARY_SERF_COUNT) == MAX_RESCUE_SERF_COUNT then
		
		SpokenMessage(String.Key("M_RescueSerfDiedCallback"))

		RescueQuestDefeatId = {}

		-- Search alive one
		for i=1,MAX_RESCUE_SERF_COUNT do
			
			if IsAlive("P4_RescueSerf_"..i) then
				table.insert(RescueQuestDefeatId, AddDefeatEntity("P4_RescueSerf_"..i, true))
			end
			
		end
		
	elseif (SerfDeadCounter + NECCSSARY_SERF_COUNT) > MAX_RESCUE_SERF_COUNT then
		
		Defeat()
		
	end
	
end

function CreateSerfNPC(_name)

	local recreateSerfNPC = {}
	recreateSerfNPC.name = _name
	
	if serfFollowTarget ~= nil then
		recreateSerfNPC.follow = serfFollowTarget
	end
	recreateSerfNPC.callback = RescueSerfNPCCallback

	CreateNPC(recreateSerfNPC)
	
end

function RescueSerfNPCCallback(_npc, _hero)

	SpokenMessage(String.Key("M_RescueSerfNPCCallback"))
	
	-- set target
	serfFollowTarget = Logic.GetEntityName(_hero)
	
	-- recreate npcs
	
	for i=1,MAX_RESCUE_SERF_COUNT do
		
		local SerfName = "P4_RescueSerf_"..i	

		if IsAlive(SerfName) then

			CreateSerfNPC(SerfName)
			
		end
		
	end

end


function UpdateAmountOfRescuedAndDeadSerfsInQuestInformation()	
	GUIQuestTools.UpdateQuestInformationString(SerfRescuedCounter .. "/" .. NECCSSARY_SERF_COUNT)
end